package com.test;
        
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.util.bridges.mvc.MVCPortlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class ZoomPortlet extends MVCPortlet {
	
	private static Log _log = LogFactoryUtil.getLog(ZoomPortlet.class);

	private static Map<String, Long> structureMap = new HashMap<String, Long>();
	private static String STRUCTURE_NAME = "Zoomable";

	private static final String ERROR = "error";

	@Override
	public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException 
	{
		try 
		{	
			// use a hardcoded tag for this example, but could get this from preferences.
			String tag = "gamble-house";
			
			ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute(WebKeys.THEME_DISPLAY);
			Long articleGroupId = themeDisplay.getSiteGroupId();
			
			long companyId = themeDisplay.getCompanyId();

			Zoomable zoomable = getZoomableFromDB(articleGroupId, companyId, themeDisplay, tag, themeDisplay.getLocale());
			renderRequest.setAttribute("zoomable", zoomable);
		} 
		catch (Exception e) 
		{
			renderRequest.setAttribute(ERROR, e.getMessage());
			_log.error("Exception occurred while rendering portlet", e);
		}
		
		super.doView(renderRequest, renderResponse);
	}
	
	private Zoomable getZoomableFromDB(long groupId, long companyId, ThemeDisplay themeDisplay, String productName, Locale locale) throws SystemException, PortalException, DocumentException, IOException
	{
		Zoomable z = null;
		
		List<AssetEntry> assetEntryList = getMatchingAssets(productName,STRUCTURE_NAME,JournalArticle.class.getName(),groupId);
		
		for (AssetEntry ae : assetEntryList)
		{
			if (JournalArticle.class.getName().equalsIgnoreCase(ae.getClassName()))
			{
				JournalArticle wc = JournalArticleLocalServiceUtil.getArticle(groupId, String.valueOf(ae.getClassPK() - 2));
				Document journalDoc = SAXReaderUtil.read(wc.getContentByLocale(themeDisplay.getLocale().toString()));
				Document titleDoc = SAXReaderUtil.read(wc.getTitle());
				
				Node mainImageNode = journalDoc.selectSingleNode(String.format("root/dynamic-element[@name='%1$s']/dynamic-content[@language-id='%2$s']", "mainImage", locale));
				Node mainTitleNode = titleDoc.selectSingleNode(String.format("//Title[@language-id='%1$s']", locale));
					
				if (mainImageNode == null)
				{
					throw new SystemException("The mainImage from the mainImageNode was null.  Ensure there is an interactiveModule translated in : " + locale);
				}
				
				z = new Zoomable(mainTitleNode.getText(), mainImageNode.getText());
				
				Node root = journalDoc.getRootElement();
				
				List<Node> pointNodes = root.selectNodes("/root/dynamic-element[@name='pointEnabled']");
				
				ZoomPoint point;
				for (int i = 0; i < pointNodes.size(); i++) 
				{	
					Node pointNode = pointNodes.get(i);
					
					Node enabledNode = pointNode.selectSingleNode(String.format("dynamic-content[@language-id='%1$s'][last()]",locale));
					Node titleNode = pointNode.selectSingleNode(String.format("dynamic-element[@name='%1$s']/dynamic-content[@language-id='%2$s']", "title", locale));
				
					if (Boolean.valueOf(enabledNode.getText()))
					{
						Node descNode = pointNode.selectSingleNode(String.format("dynamic-element[@name='%1$s']/dynamic-content[@language-id='%2$s']", "description", locale));						
						Node imageNode = pointNode.selectSingleNode(String.format("dynamic-element[@name='%1$s']/dynamic-content[@language-id='%2$s']", "image", locale));
						Node xNode = pointNode.selectSingleNode(String.format("dynamic-element[@name='%1$s']/dynamic-content[@language-id='%2$s']", "x", locale));
						Node yNode = pointNode.selectSingleNode(String.format("dynamic-element[@name='%1$s']/dynamic-content[@language-id='%2$s']", "y", locale));
						
						z.addPoint(titleNode.getText(),descNode.getText(),imageNode.getText(),Integer.valueOf(xNode.getText()),Integer.valueOf(yNode.getText()));			
					}
				}
			}
		}
		
		return z;
	}
	
	public List<AssetEntry> getMatchingAssets(String tag,String structureName, String requiredClassName, Long groupId)
			throws SystemException, PortalException 
	{	
		String[] tagNames = { tag };
		
		long[] tagIds = AssetTagLocalServiceUtil.getTagIds(groupId, tagNames);

		if (tagIds.length == 0)	{
			throw new SystemException("Attempting to get TagIds for tag '" + tag + "', but found none.  Please make sure there are '"+structureName+"' WebContents tagged with '" + tag + "'. and groupId: " + groupId);
		}

		long[] requiredClassIds = { PortalUtil.getClassNameId(requiredClassName) };
		long structureId = getStructureId(structureName);

		AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
		assetEntryQuery.setClassTypeIds(new long[] { structureId });
		assetEntryQuery.setAllTagIds(tagIds);
		assetEntryQuery.setClassNameIds(requiredClassIds);

		return AssetEntryLocalServiceUtil.getEntries(assetEntryQuery);
	}

	private static long getStructureId(String structureName) throws SystemException {
		
		if (structureMap.isEmpty())
		{	
			List<DDMStructure> structures = DDMStructureLocalServiceUtil.getStructures();
			
			for (DDMStructure currentStructure : structures)
			{
				Document document=null;
				try {
					document = SAXReaderUtil.read(currentStructure.getName());
				} catch (DocumentException e) {
					e.printStackTrace();
				}
				
				Node node = document.selectSingleNode("/root/Name");
				String currentStructureName = node.getText();
				Long currentStructureId = currentStructure.getStructureId();
				
				structureMap.put(currentStructureName, currentStructureId);
			}	
		}
		
		return structureMap.get(structureName);
	}
}