<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://liferay.com/tld/aui" prefix="aui"%>
<%@ taglib uri="http://liferay.com/tld/portlet" prefix="liferay-portlet"%>
<%@ taglib uri="http://liferay.com/tld/theme" prefix="liferay-theme"%>
<%@ taglib uri="http://liferay.com/tld/ui" prefix="liferay-ui"%>
<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ page import="javax.portlet.ActionRequest"%>
<%@ page import="com.test.Zoomable"%>

<liferay-theme:defineObjects />
<portlet:defineObjects />

<c:choose>
   <c:when test="${not empty requestScope.error}">
      <div class="portlet-msg-error">
         <c:out value='${error}' />
      </div>
   </c:when>
   <c:otherwise>
      <div>
         <div class="carousel-container animated fadeIn" style="overflow:auto">
            <div class="row-fluid">
               <div class="span10">
                  <h3 class="outside-text">
                     Zoom to see Details: <c:out value='${requestScope.zoomable.title}'/>
                  </h3>
               </div>
            </div>
            <div class="row-fluid options" >
               <div class="main-module animated slideInRight">
                  <div class="tooltips animated bounceInDown">
                     <c:forEach var="point" items="${requestScope.zoomable.points}">
                        <div id="point3" class="rotate point modulePoint" 
                           data-img="<c:out value='${point.image}'/>" data-title="<c:out value='${point.title}'/>" data-desc="<c:out value='${point.desc}'/>"
                           style="top:<c:out value='${point.y}'/>px;left: <c:out value='${point.x}'/>px;"							
                           onClick="var image = $(this).attr('data-img');							
                           $('.main-module > img').animate({zoom:1.3, opacity:0.0 }, 500);
                           $('.tooltips').toggle();
                           $('.zoomImage > img').attr('src', image);
                           $('.zoom-module').css({display: 'block'});
                           $('.zoom-module').show();
                           $('#zoomTitle').html($(this).attr('data-title'));
                           $('.zoomOutClose').show();
                           $('#zoomDesc').html($(this).attr('data-desc'));">
                           <i class="fa fa-search-plus"></i> 							
                        </div>
                     </c:forEach>
                  </div>
                  <image src="<c:out value='${requestScope.zoomable.mainImage}'/>" />
               </div>
            </div>
            <div class="zoom-module">
               <div onClick="var points = $('.tooltips');
                  var zoomModule = $('.zoom-module');
                  zoomModule.addClass('fadeOut');
                  $('.main-module > img').animate({zoom:1, opacity:1.0}, 500);
                  zoomModule.removeClass('animated fadeIn');
                  zoomModule.css({display: 'none'});
                  points.toggle();" id="zoomOut" class="close">
                  <span class="smalltext">Close<i class="fa fa-search-minus"></i></span>
               </div>
               <div class="row-fluid">
                  <div class="zoomText animated fadeIn span6">
                     <h2 id="zoomTitle"></h2>
                     <p id="zoomDesc"></p>
                  </div>
                  <div class="zoomImage animated slideInRight span6">
                     <img src="" style="">
                  </div>
               </div>
            </div>
         </div>
      </div>
   </c:otherwise>
</c:choose>